<?php
    /*
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    $templateEmail = $geecomDb->leggiSingolaRiga("geec_templateEmail",1);
    
    $queryTemplateEmail = "SELECT * FROM geec_templateEmail";
    $risTemplateEmail   = $geecomDb->eseguiQueryLettura($queryTemplateEmail);
    
    $idTemplate = isset($_GET["idTemplate"]) ? filter_input(INPUT_GET,"idTemplate",FILTER_SANITIZE_NUMBER_INT) : 1;
    
?>
<h4 class="mb-4 title">Template email</h4>
<ul class="nav nav-pills" id="..." role="tablist">
    <?php 
        while($templateEmail = $risTemplateEmail->fetch_assoc()) {
            
            $stringaAttivo = ($templateEmail["id"] == $idTemplate) ? "active" : "";
    ?>
    <li class="nav-item" role="presentation">
        <a class="nav-link <?php echo $stringaAttivo ?>" data-toggle="pill" href="#template<?php echo $templateEmail["id"] ?>" role="tab" aria-controls="pills-home" aria-selected="true"><?php echo $templateEmail["nome"] ?></a>
    </li>
    <?php
        }
    ?>
    <li class="nav-item" role="presentation">
        <a class="nav-link btn btn-sm btn-outline-primary ml-3" data-toggle="pill" href="#nuovoTemplate" role="tab" aria-controls="pills-home" aria-selected="true">Aggiungi nuovo<i class="fas fa-plus ml-2"></i></a>
    </li>
</ul>

<div class="tab-content">
    <?php 
        $queryTemplateEmail = "SELECT * FROM geec_templateEmail";
        $risTemplateEmail   = $geecomDb->eseguiQueryLettura($queryTemplateEmail);
        while($templateEmail = $risTemplateEmail->fetch_assoc()) {
            $stringaAttivo = ($templateEmail["id"] == $idTemplate) ? "active" : "";
    ?>
        <div id="template<?php echo $templateEmail["id"] ?>" class="tab-pane fade show px-0 shadow-none <?php echo $stringaAttivo ?>" role="tabpanel">
            <form class="form-horizontal" role="form" name="formImpostazioniTemplateEmail<?php echo $templateEmail["id"] ?>" action="../controller/controllerImpostazioni.php" method="post" enctype="multipart/form-data">
                <input type="text" class="d-none" name="operazione" value="aggiornaTemplateEmail">
                <input type="text" class="d-none" name="id" value="<?php echo $templateEmail["id"] ?>">

                <div class="mb-3">
                    <h6>Nome</h6>
                    <input type="text" class="form-control" name="nome" value="<?php echo $templateEmail["nome"] ?>">
                </div>
                <div class="mb-3">
                    <h6>CSS</h6>
                    <textarea class="form-control" rows="15" id="css" name="css"><?php echo $templateEmail["css"] ?></textarea>
                </div>
                <div class="mb-3">
                    <h6>Corpo</h6>
                    <textarea class="form-control" rows="15" id="testoFooter" name="corpoMail"><?php echo $templateEmail["corpoMail"] ?></textarea>
                </div>
                <div class="mb-0">
                    <h6>Footer</h6>
                    <textarea class="form-control" rows="15" id="testoFooter" name="footerMail"><?php echo $templateEmail["footerMail"] ?></textarea>
                </div>
                <button type="button" class="btn btn-primary float-right ml-3 mt-3" onclick="document.formImpostazioniTemplateEmail<?php echo $templateEmail["id"] ?>.submit()"><i class="fas fa-check"></i> Salva </button>
            </form>
        </div>
    <?php
        }
    ?>
    <div id="nuovoTemplate" class="tab-pane fade show px-0 shadow-none" role="tabpanel">
        <form class="form-horizontal" role="form" name="formNuovoTemplateEmail" action="../controller/controllerImpostazioni.php" method="post" enctype="multipart/form-data">
            <input type="text" class="d-none" name="operazione" value="creaTemplateEmail">
            <input type="text" class="d-none" name="id" value="0">

            <div class="mb-3">
                <h6>Nome</h6>
                <input type="text" class="form-control" name="nome" value="">
            </div>
            <div class="mb-3">
                <h6>CSS</h6>
                <textarea class="form-control" rows="15" id="css" name="css"></textarea>
            </div>
            <div class="mb-3">
                <h6>Corpo</h6>
                <textarea class="form-control" rows="15" id="testoFooter" name="corpoMail"></textarea>
            </div>
            <div class="mb-0">
                <h6>Footer</h6>
                <textarea class="form-control" rows="15" id="testoFooter" name="footerMail"></textarea>
            </div>
            <button type="button" class="btn btn-primary float-right ml-3 mt-3" onclick="document.formNuovoTemplateEmail.submit()"><i class="fas fa-check"></i> Crea </button>
        </form>
    </div>
</div>